/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.network.client.data;

import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandAlignment;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandPose;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandScreenType;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOptions;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface DataSyncHandler {
    public ArmorStandHolder getArmorStandHolder();

    default public ArmorStand getArmorStand() {
        return this.getArmorStandHolder().getArmorStand();
    }

    public void sendName(String var1);

    public void sendPose(ArmorStandPose var1);

    default public void sendPose(ArmorStandPose pose, boolean finalize) {
        this.sendPose(pose);
    }

    @Nullable
    default public ArmorStandPose getLastSyncedPose() {
        return null;
    }

    public void sendPosition(double var1, double var3, double var5);

    default public void sendPosition(double posX, double posY, double posZ, boolean finalize) {
        this.sendPosition(posX, posY, posZ);
    }

    public void sendRotation(float var1);

    default public void sendRotation(float rotation, boolean finalize) {
        this.sendRotation(rotation);
    }

    public void sendStyleOption(ArmorStandStyleOption var1, boolean var2);

    default public void sendStyleOption(ArmorStandStyleOption styleOption, boolean value, boolean finalize) {
        this.sendStyleOption(styleOption, value);
    }

    default public void sendAlignment(ArmorStandAlignment alignment) {
        if (!this.getArmorStand().m_20145_()) {
            this.sendStyleOption(ArmorStandStyleOptions.INVISIBLE, true, false);
        }
        if (!this.getArmorStand().m_20068_()) {
            this.sendStyleOption(ArmorStandStyleOptions.NO_GRAVITY, true, false);
        }
        this.sendPose(alignment.getPose(), false);
        Vec3 alignmentOffset = alignment.getAlignmentOffset(this.getArmorStand().m_31666_());
        Vec3 newPosition = DataSyncHandler.getLocalPosition((Entity)this.getArmorStand(), alignmentOffset);
        this.sendPosition(newPosition.m_7096_(), newPosition.m_7098_(), newPosition.m_7094_(), false);
        this.finalizeCurrentOperation();
    }

    private static Vec3 getLocalPosition(Entity entity, Vec3 offset) {
        Vec2 vec2 = entity.m_20155_();
        Vec3 vec3 = entity.m_20182_();
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float g = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float h = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float i = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float j = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float k = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec32 = new Vec3((double)(f * h), (double)i, (double)(g * h));
        Vec3 vec33 = new Vec3((double)(f * j), (double)k, (double)(g * j));
        Vec3 vec34 = vec32.m_82537_(vec33).m_82490_(-1.0);
        double d = vec32.f_82479_ * offset.m_7094_() + vec33.f_82479_ * offset.m_7098_() + vec34.f_82479_ * offset.m_7096_();
        double e = vec32.f_82480_ * offset.m_7094_() + vec33.f_82480_ * offset.m_7098_() + vec34.f_82480_ * offset.m_7096_();
        double l = vec32.f_82481_ * offset.m_7094_() + vec33.f_82481_ * offset.m_7098_() + vec34.f_82481_ * offset.m_7096_();
        return new Vec3(vec3.f_82479_ + d, vec3.f_82480_ + e, vec3.f_82481_ + l);
    }

    default public ArmorStandScreenType[] getScreenTypes() {
        return (ArmorStandScreenType[])Stream.of(this.getArmorStandHolder().getDataProvider().getScreenTypes()).filter(this::supportsScreenType).toArray(ArmorStandScreenType[]::new);
    }

    default public boolean supportsScreenType(ArmorStandScreenType screenType) {
        return true;
    }

    default public void tick() {
    }

    default public boolean shouldContinueTicking() {
        return false;
    }

    default public void finalizeCurrentOperation() {
    }

    public static void setCustomArmorStandName(ArmorStand armorStand, String name) {
        if ((name = SharedConstants.m_136190_((String)name)).length() <= 50) {
            boolean remove = name.isBlank() || name.equals(EntityType.f_20529_.m_20676_().getString());
            armorStand.m_6593_((Component)(remove ? null : Component.m_237113_((String)name)));
        }
    }
}

